package org.elsfs.tool.sql.order;

import java.util.List;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 多字段排序
 *
 * @author zeng
 * @version 0.0.4
 */
public class CompositeOrderItem implements OrderItem {

  /** 排序条件项列表 */
  private final List<OrderItem> orderItems;

  public CompositeOrderItem(List<OrderItem> orderItems) {
    this.orderItems = orderItems;
  }

  /**
   * 添加排序项
   *
   * @param orderItem 排序项
   */
  public void addOrderItem(OrderItem orderItem) {
    this.orderItems.add(orderItem);
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "ORDER BY {}",
        this.orderItems.stream()
            .map(OrderItem::buildSqlFragment)
            .collect(Collectors.joining(SqlPool.COMMA_WITH_SPACE)));
  }
}
