package org.elsfs.tool.sql.order;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;

/**
 * 降序排序
 *
 * @author zeng
 * @version 0.0.4
 */
public class DescOrderItem implements OrderItem {

  /** 字段名称 */
  private final String field;

  public DescOrderItem(String field) {
    this.field = field;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format("{} DESC", NamingCase.toUnderlineCase(this.field));
  }
}
