package org.elsfs.tool.sql.select;

import java.util.List;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlFragment;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 聚合选择项
 *
 * @author zeng
 * @version 0.0.4
 */
public class CompositeSelectItem implements SelectItem {

  /** 选择项列表 */
  private final List<SelectItem> selectItems;

  public CompositeSelectItem(List<SelectItem> selectItems) {
    this.selectItems = selectItems;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "SELECT {}",
        this.selectItems.stream()
            .map(SqlFragment::buildSqlFragment)
            .collect(Collectors.joining(SqlPool.COMMA_WITH_SPACE)));
  }
}
