package org.elsfs.tool.sql.select;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 子查询选择项实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class SubQuerySelectItem implements SelectItem {

  /** 子查询SQL */
  private final String subQuerySql;

  /** 字段名别 */
  private final String fieldAlias;

  public SubQuerySelectItem(String subQuerySql, String fieldAlias) {
    this.subQuerySql = subQuerySql;
    this.fieldAlias = fieldAlias;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "({}) {} {}",
        this.subQuerySql,
        SqlPool.AS_KEYWORD,
        NamingCase.toUnderlineCase(this.fieldAlias));
  }
}
