package org.elsfs.tool.sql.service;

import java.awt.print.Pageable;
import java.util.List;
import org.elsfs.tool.sql.page.Page;

/**
 * the is {@link SearchableService}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface SearchableService<E> extends PageableService<E> {

  /**
   * 获取搜索数据
   *
   * @param searchForm 搜索表单
   * @return 实体对象列表
   */
  List<E> fetchList(E searchForm);

  /**
   * 获取搜索分页数据
   *
   * @param pageable 分页对象
   * @return 分页数据对象
   */
  Page<E> fetchPage(Pageable pageable);
}
