package org.elsfs.tool.sql.singular.facade;

import java.util.Set;
import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.sql.common.FieldEnumResolverSupport;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * SQL条件字段
 *
 * @author zeng
 * @since 0.0.4
 */
public class ConditionFields {

  /** 字段名称集合 */
  private final Set<String> fieldNames;

  /** 表别名管理器 */
  private final TableAliasManager tableAliasManager;

  public ConditionFields(Set<String> fieldNames, TableAliasManager tableAliasManager) {
    this.fieldNames = fieldNames;
    this.tableAliasManager = tableAliasManager;
  }

  /**
   * 判断条件是否有指定字段
   *
   * @param field 字段名称（应包含表别名）
   * @return bool
   */
  public boolean hasField(String field) {
    return this.fieldNames.contains(NamingCase.toUnderlineCase(field));
  }

  /**
   * 判断条件是否有指定字段
   *
   * @param tableAlias 表别名
   * @param field 字段名称（不包含表别名）
   * @return bool
   */
  public boolean hasField(String tableAlias, String field) {
    return this.fieldNames.contains(tableAlias + SqlPool.DOT + NamingCase.toUnderlineCase(field));
  }

  /**
   * 判断条件是否有指定字段
   *
   * @param entityClass 表实体类
   * @param field 字段名称（不包含表别名）
   * @return bool
   */
  public boolean hasField(Class<?> entityClass, String field) {
    return this.fieldNames.contains(
        this.tableAliasManager.fetchTableAlias(entityClass)
            + SqlPool.DOT
            + NamingCase.toUnderlineCase(field));
  }

  /**
   * 判断条件是否有指定字段
   *
   * @param field 字段名称枚举
   * @return bool
   */
  public boolean hasField(Enum<?> field) {
    return this.fieldNames.contains(
        NamingCase.toUnderlineCase(
            FieldEnumResolverSupport.resolveFieldName(this.tableAliasManager, field)));
  }
}
