package org.elsfs.tool.sql.singular.facade;

import java.util.function.Consumer;
import org.elsfs.tool.sql.interfaces.Expression;
import org.elsfs.tool.sql.interfaces.single.Between;
import org.elsfs.tool.sql.interfaces.single.Eq;
import org.elsfs.tool.sql.interfaces.single.Ge;
import org.elsfs.tool.sql.interfaces.single.Gt;
import org.elsfs.tool.sql.interfaces.single.In;
import org.elsfs.tool.sql.interfaces.single.IsNotNull;
import org.elsfs.tool.sql.interfaces.single.IsNull;
import org.elsfs.tool.sql.interfaces.single.Le;
import org.elsfs.tool.sql.interfaces.single.Like;
import org.elsfs.tool.sql.interfaces.single.LikeLeft;
import org.elsfs.tool.sql.interfaces.single.LikeRight;
import org.elsfs.tool.sql.interfaces.single.Lt;
import org.elsfs.tool.sql.interfaces.single.Ne;
import org.elsfs.tool.sql.interfaces.single.NotBetween;
import org.elsfs.tool.sql.interfaces.single.NotIn;
import org.elsfs.tool.sql.interfaces.single.NotLike;

/**
 * 条件操作
 *
 * @param <Children> 子类类型
 * @author zeng
 * @since 0.0.4
 */
public interface ConditionOperations<Children>
    extends Eq<Children>,
        Ne<Children>,
        Gt<Children>,
        Ge<Children>,
        Lt<Children>,
        Le<Children>,
        Between<Children>,
        NotBetween<Children>,
        Like<Children>,
        NotLike<Children>,
        LikeLeft<Children>,
        LikeRight<Children>,
        In<Children>,
        NotIn<Children>,
        Expression<Children>,
        IsNull<Children>,
        IsNotNull<Children> {

  /**
   * 拼接 EXISTS ( sql语句 )
   *
   * <p>!! sql 注入方法 !!
   *
   * <p>例: exists("select id from table where age = 1")
   *
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  Children exists(String sqlValue, Object... values);

  /**
   * 拼接 EXISTS ( sql语句 )
   *
   * <p>!! sql 注入方法 !!
   *
   * <p>例: exists("select id from table where age = 1")
   *
   * @param condition 执行条件
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  Children exists(boolean condition, String sqlValue, Object... values);

  /**
   * 拼接 NOT EXISTS ( sql语句 )
   *
   * <p>!! sql 注入方法 !!
   *
   * <p>例: notExists("select id from table where age = 1")
   *
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  Children notExists(String sqlValue, Object... values);

  /**
   * 拼接 NOT EXISTS ( sql语句 )
   *
   * <p>!! sql 注入方法 !!
   *
   * <p>例: notExists("select id from table where age = 1")
   *
   * @param condition 执行条件
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  Children notExists(boolean condition, String sqlValue, Object... values);

  /**
   * 应用action消费器
   *
   * @param actionConsumer action消费器
   * @return 具体实现
   */
  Children apply(Consumer<Children> actionConsumer);

  /**
   * 应用action消费器
   *
   * @param condition 条件
   * @param actionConsumer action消费器
   * @return 具体实现
   */
  Children apply(boolean condition, Consumer<Children> actionConsumer);

  /**
   * 拼接 OR
   *
   * @return children
   */
  Children or();

  /**
   * 拼接 OR
   *
   * @param condition 执行条件
   * @return children
   */
  Children or(boolean condition);

  /**
   * OR 嵌套
   *
   * <p>例: or(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param consumer 消费函数
   * @return children
   */
  Children or(Consumer<Children> consumer);

  /**
   * OR 嵌套
   *
   * <p>例: or(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param condition 执行条件
   * @param consumer 消费函数
   * @return children
   */
  Children or(boolean condition, Consumer<Children> consumer);

  /**
   * 正常嵌套 不带 AND 或者 OR
   *
   * <p>例: nested(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param consumer 消费函数
   * @return children
   */
  Children nested(Consumer<Children> consumer);

  /**
   * 正常嵌套 不带 AND 或者 OR
   *
   * <p>例: nested(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param condition 执行条件
   * @param consumer 消费函数
   * @return children
   */
  Children nested(boolean condition, Consumer<Children> consumer);

  /**
   * AND 嵌套
   *
   * <p>例: and(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param consumer 消费函数
   * @return children
   */
  Children and(Consumer<Children> consumer);

  /**
   * AND 嵌套
   *
   * <p>例: and(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param condition 执行条件
   * @param consumer 消费函数
   * @return children
   */
  Children and(boolean condition, Consumer<Children> consumer);
}
