package org.elsfs.tool.sql.singular.facade;

/**
 * 分页操作
 *
 * @param <C> 具体实现
 * @author venus
 * @author zeng
 * @since 0.0.4
 */
public interface LimitOperations<C extends LimitOperations<C>> {

  /**
   * 限制查询数量
   *
   * @param num 数量
   * @return 具体实现
   */
  C limit(long num);

  /**
   * 限制查询数量
   *
   * @param condition 执行条件
   * @param num 数量
   * @return 具体实现
   */
  C limit(boolean condition, long num);
}
