package org.elsfs.tool.sql.singular.facade;

import org.elsfs.tool.sql.interfaces.Join;

/**
 * 查询动作
 *
 * @param <R> 返回类型
 * @author zeng
 * @since 0.0.4
 */
public interface QueryAction<R>
    extends DbAction<R>,
        QueryOperations<QueryAction<R>>,
        LimitOperations<QueryAction<R>>,
        JoinOperations<
            QueryAction<R>,
            QueryAction.ActionSelectJoinBuilder<R>,
            QueryAction.ActionJoinConditionBuilder<R>>,
        ConditionFieldsAware {

  /**
   * 清空默认选择字段
   *
   * @return 具体实现
   */
  QueryAction<R> clearDefaultSelectedFields();

  /**
   * 快速关联实体
   *
   * @param relationDescriptor 关联描述符对象
   * @return this
   */
  QueryAction<R> associate(EntityRelationDescriptor relationDescriptor);

  /**
   * Join构建器
   *
   * @param <R> 结果类型
   */
  interface ActionSelectJoinBuilder<R>
      extends Join.SelectJoinBuilder<
          ActionSelectJoinBuilder<R>, ActionJoinConditionBuilder<R>, QueryAction<R>> {}

  /**
   * Join条件构建器
   *
   * @param <R> 结果类型
   */
  interface ActionJoinConditionBuilder<R>
      extends Join.JoinConditionBuilder<
          ActionJoinConditionBuilder<R>, ActionSelectJoinBuilder<R>, QueryAction<R>> {}
}
