package org.elsfs.tool.sql.singular.facade;

/**
 * 更新操作
 *
 * @param <C> 子类类型
 * @author zeng
 * @since 0.0.4
 */
public interface UpdateOperations<C extends UpdateOperations<C>>
    extends ConditionOperations<C>, LimitOperations<C> {

  /**
   * 设置值
   *
   * @param field 表字段名
   * @param value 值
   * @return 具体实现
   */
  C set(String field, Object value);

  /**
   * 设置值
   *
   * @param field 表字段枚举
   * @param value 值
   * @return 具体实现
   */
  C set(Enum<?> field, Object value);

  /**
   * 设置值
   *
   * @param condition 是否应用设置
   * @param field 表字段名
   * @param value 值
   * @return 具体实现
   */
  C set(boolean condition, String field, Object value);

  /**
   * 设置值
   *
   * @param condition 是否应用设置
   * @param field 表字段枚举
   * @param value 值
   * @return 具体实现
   */
  C set(boolean condition, Enum<?> field, Object value);

  /**
   * 设置SQL
   *
   * @param sqlValue SQL片段：name=xxx
   * @return 具体实现
   */
  C setSql(String sqlValue);

  /**
   * 设置SQL
   *
   * @param condition 是否应用设置SQL
   * @param sqlValue SQL片段：name=xxx
   * @return 具体实现
   */
  C setSql(boolean condition, String sqlValue);
}
