package org.elsfs.tool.sql.update;

import java.util.Collection;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlFragment;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 聚合更新设置项实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class CompositeSetItem implements SetItem {

  /** 更新设置项集合 */
  private final Collection<SetItem> setItems;

  public CompositeSetItem(Collection<SetItem> setItems) {
    this.setItems = setItems;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "SET {}",
        this.setItems.stream()
            .map(SqlFragment::buildSqlFragment)
            .collect(Collectors.joining(SqlPool.COMMA_WITH_SPACE)));
  }
}
