package org.elsfs.tool.sql.update;

import org.elsfs.tool.core.text.StrFormatter;

/**
 * 更新表标准实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class StandardUpdateItem implements UpdateItem {

  /** 表名 */
  private final String table;

  /** 表别名 */
  private final String tableAlias;

  public StandardUpdateItem(String table, String tableAlias) {
    this.table = table;
    this.tableAlias = tableAlias;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    if (this.tableAlias == null) {
      return this.table;
    }

    return StrFormatter.format("{} AS {}", this.table, this.tableAlias);
  }
}
