/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.abs;

import java.util.ArrayList;
import java.util.Collection;
import org.elsfs.tool.sql.abs.AbstractJoin;
import org.elsfs.tool.sql.abs.AbstractSortableConditionBuilder;
import org.elsfs.tool.sql.delete.CompositeDeleteItem;
import org.elsfs.tool.sql.delete.DeleteItem;
import org.elsfs.tool.sql.delete.StandardDeleteItem;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.from.FromItem;
import org.elsfs.tool.sql.from.StandardFromItem;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.interfaces.TokenSqlFragment;
import org.elsfs.tool.sql.interfaces.delete.DeleteSql;
import org.elsfs.tool.sql.utils.CastUtils;

public abstract class AbstractDeleteSql<C extends AbstractDeleteSql<C>>
extends AbstractJoin<C>
implements DeleteSql<C, DeleteConditionBuilderImpl> {
    protected final C childThis = (AbstractDeleteSql)CastUtils.cast(this);
    private DeleteConditionBuilderImpl deleteConditionBuilder;
    private FromItem fromItem;
    private final Collection<DeleteItem> deleteItems = new ArrayList<DeleteItem>();

    @Override
    protected abstract String getTableName(Class<?> var1);

    @Override
    public C delete(String tableAlias) {
        this.deleteItems.add(new StandardDeleteItem(tableAlias));
        return this.childThis;
    }

    @Override
    public C delete(String ... tableAliases) {
        for (String tableAlias : tableAliases) {
            this.deleteItems.add(new StandardDeleteItem(tableAlias));
        }
        return this.childThis;
    }

    @Override
    public C delete(Collection<String> tableAliases) {
        for (String tableAlias : tableAliases) {
            this.deleteItems.add(new StandardDeleteItem(tableAlias));
        }
        return this.childThis;
    }

    @Override
    public C from(Class<?> entityClass) {
        this.fromItem = new StandardFromItem(this.getTableName(entityClass), null);
        return this.childThis;
    }

    @Override
    public C from(String table) {
        this.fromItem = new StandardFromItem(table, null);
        return this.childThis;
    }

    @Override
    public C from(Class<?> entityClass, String tableAlias) {
        this.fromItem = new StandardFromItem(this.getTableName(entityClass), tableAlias);
        return this.childThis;
    }

    @Override
    public C from(String table, String tableAlias) {
        this.fromItem = new StandardFromItem(table, tableAlias);
        return this.childThis;
    }

    @Override
    public DeleteSql.DeleteConditionBuilder<DeleteConditionBuilderImpl, C> where() {
        if (this.deleteConditionBuilder == null) {
            this.deleteConditionBuilder = new DeleteConditionBuilderImpl();
        }
        return this.deleteConditionBuilder;
    }

    @Override
    protected void beforeBuild() {
        this.addSqlFragment(new TokenSqlFragment("DELETE"));
        if (!this.deleteItems.isEmpty()) {
            this.addSqlFragment(new CompositeDeleteItem(this.deleteItems));
        }
        if (this.fromItem == null) {
            throw new SqlBuilderException("\u5220\u9664SQL\u7684\u8868\u5fc5\u987b\u6307\u5b9a");
        }
        this.addSqlFragment(this.fromItem);
        super.beforeBuild();
        if (this.deleteConditionBuilder != null) {
            this.addSqlFragment(this.deleteConditionBuilder);
        }
    }

    public class DeleteConditionBuilderImpl
    extends AbstractSortableConditionBuilder<DeleteConditionBuilderImpl>
    implements DeleteSql.DeleteConditionBuilder<DeleteConditionBuilderImpl, C> {
        @Override
        public C end() {
            return AbstractDeleteSql.this.childThis;
        }

        @Override
        public SqlParameterManager getSqlParameterManager() {
            return AbstractDeleteSql.this.getSqlParameterManager();
        }

        @Override
        public TableAliasManager getTableAliasManager() {
            return AbstractDeleteSql.this.getTableAliasManager();
        }
    }
}

