/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.abs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrUtils;
import org.elsfs.tool.core.util.CollectionUtils;
import org.elsfs.tool.sql.abs.CompositeSqlFragment;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.insert.StandardInsertIntoItem;
import org.elsfs.tool.sql.insert.StandardValuesItem;
import org.elsfs.tool.sql.interfaces.SqlParameterManagerAware;
import org.elsfs.tool.sql.interfaces.TokenSqlFragment;
import org.elsfs.tool.sql.interfaces.inset.InsertSql;
import org.elsfs.tool.sql.update.CompositeSetItem;
import org.elsfs.tool.sql.update.ExpressionSetItem;
import org.elsfs.tool.sql.update.SetItem;
import org.elsfs.tool.sql.update.StandardSetItem;
import org.elsfs.tool.sql.utils.CastUtils;

public abstract class AbstractInsertSql<C extends AbstractInsertSql<C>>
extends CompositeSqlFragment
implements InsertSql<C>,
SqlParameterManagerAware {
    protected final C childThis = (AbstractInsertSql)CastUtils.cast(this);
    private String table;
    private Collection<String> insertFields = Collections.emptyList();
    private String conflictConstraint;
    private final Collection<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
    private boolean hasConflictHandling;
    private InsertSql.ConflictUpdateSql<C> conflictUpdateSql;
    private boolean ignoreConflict;

    protected abstract String getTableName(Class<?> var1);

    @Override
    public C insertInto(Class<?> entityClass) {
        this.table = this.getTableName(entityClass);
        return this.childThis;
    }

    @Override
    public C insertInto(String table) {
        this.table = table;
        return this.childThis;
    }

    @Override
    public C fields(String ... fields) {
        this.insertFields = Arrays.asList(fields);
        return this.childThis;
    }

    @Override
    public C fields(Enum<?> ... fields) {
        this.insertFields = Arrays.stream(fields).map(Enum::name).toList();
        return this.childThis;
    }

    @Override
    public C fields(Collection<String> fields) {
        this.insertFields = new ArrayList<String>(fields);
        return this.childThis;
    }

    @Override
    public C fieldsEnum(Collection<Enum<?>> fields) {
        this.insertFields = fields.stream().map(Enum::name).toList();
        return this.childThis;
    }

    @Override
    public C values(Map<String, Object> value) {
        if (value == null) {
            throw new SqlBuilderException("\u63d2\u5165\u503cMap\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.values.add(value);
        return this.childThis;
    }

    @Override
    public C values(Collection<Map<String, Object>> values) {
        if (CollectionUtils.isEmpty(values)) {
            throw new SqlBuilderException("\u63d2\u5165\u503cMap\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.values.addAll(values);
        return this.childThis;
    }

    @Override
    public C onConflict(String constraintName) {
        this.conflictConstraint = constraintName;
        this.hasConflictHandling = true;
        return this.childThis;
    }

    @Override
    public C doNothing() {
        this.ignoreConflict = true;
        return this.childThis;
    }

    @Override
    public InsertSql.ConflictUpdateSql<C> doUpdate() {
        this.ignoreConflict = false;
        this.conflictUpdateSql = new ConflictUpdateSqlImpl();
        return this.conflictUpdateSql;
    }

    @Override
    protected void beforeBuild() {
        this.addSqlFragment(new StandardInsertIntoItem(this.table, this.insertFields));
        this.addSqlFragment(new StandardValuesItem(this.getSqlParameterManager(), this.insertFields, this.values));
        if (this.hasConflictHandling) {
            if (StrUtils.isBlank((String)this.conflictConstraint)) {
                throw new SqlBuilderException("UPSERT\u8bed\u53e5\u51b2\u7a81\u7684\u7ea6\u675f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.addSqlFragment(new TokenSqlFragment("ON CONFLICT ON CONSTRAINT " + this.conflictConstraint));
            if (this.ignoreConflict) {
                this.addSqlFragment(new TokenSqlFragment("DO NOTHING"));
            } else {
                this.addSqlFragment(new TokenSqlFragment("DO UPDATE"));
                this.addSqlFragment(this.conflictUpdateSql);
            }
        }
    }

    public class ConflictUpdateSqlImpl
    implements InsertSql.ConflictUpdateSql<C> {
        private static final String EXCLUDE_FIELD_PREFIX = "excluded.";
        private final Collection<SetItem> setItems = new ArrayList<SetItem>();

        @Override
        public C end() {
            return AbstractInsertSql.this.childThis;
        }

        @Override
        public InsertSql.ConflictUpdateSql<C> setConflict(String field, String excludedField) {
            this.setItems.add(new ExpressionSetItem(field, EXCLUDE_FIELD_PREFIX + NamingCase.toUnderlineCase((CharSequence)excludedField), null));
            return this;
        }

        @Override
        public InsertSql.ConflictUpdateSql<C> setConflict(Enum<?> field, Enum<?> excludedField) {
            this.setItems.add(new ExpressionSetItem(field.name(), EXCLUDE_FIELD_PREFIX + NamingCase.toUnderlineCase((CharSequence)excludedField.name()), null));
            return this;
        }

        @Override
        public InsertSql.ConflictUpdateSql<C> set(String field, String expression, Object ... args) {
            this.setItems.add(new ExpressionSetItem(field, expression, args));
            return this;
        }

        @Override
        public InsertSql.ConflictUpdateSql<C> set(Enum<?> field, String expression, Object ... args) {
            this.setItems.add(new ExpressionSetItem(field.name(), expression, args));
            return this;
        }

        @Override
        public InsertSql.ConflictUpdateSql<C> setValue(String field, Object value) {
            this.setItems.add(new StandardSetItem(AbstractInsertSql.this.getSqlParameterManager(), field, value));
            return this;
        }

        @Override
        public InsertSql.ConflictUpdateSql<C> setValue(Enum<?> field, Object value) {
            this.setItems.add(new StandardSetItem(AbstractInsertSql.this.getSqlParameterManager(), field.name(), value));
            return this;
        }

        @Override
        public InsertSql.ConflictUpdateSql<C> setValues(Map<String, Object> fieldValueMap) {
            for (Map.Entry<String, Object> entry : fieldValueMap.entrySet()) {
                this.setValue(entry.getKey(), entry.getValue());
            }
            return this;
        }

        @Override
        public InsertSql.ConflictUpdateSql<C> setValuesEnum(Map<Enum<?>, Object> fieldValueMap) {
            for (Map.Entry<Enum<?>, Object> entry : fieldValueMap.entrySet()) {
                this.setValue((Enum)entry.getKey(), entry.getValue());
            }
            return this;
        }

        @Override
        public String buildSqlFragment() {
            if (!AbstractInsertSql.this.ignoreConflict && this.setItems.isEmpty()) {
                throw new SqlBuilderException("\u51b2\u7a81\u66f4\u65b0SQL\u5fc5\u987b\u8bbe\u7f6e\u66f4\u65b0\u9879");
            }
            return new CompositeSetItem(this.setItems).buildSqlFragment();
        }
    }
}

