/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.abs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.abs.AbstractCondition;
import org.elsfs.tool.sql.abs.AbstractSortableCondition;
import org.elsfs.tool.sql.condition.ConditionItem;
import org.elsfs.tool.sql.group.GroupByItem;
import org.elsfs.tool.sql.group.StandardGroupBy;
import org.elsfs.tool.sql.interfaces.SqlFragment;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.interfaces.TokenSqlFragment;
import org.elsfs.tool.sql.interfaces.select.SelectCondition;
import org.elsfs.tool.sql.limit.LimitItem;
import org.elsfs.tool.sql.offset.OffsetItem;
import org.elsfs.tool.sql.offset.StandardOffsetItem;
import org.elsfs.tool.sql.order.CompositeOrderItem;
import org.elsfs.tool.sql.order.OrderItem;

public abstract class AbstractSelectCondition<C extends AbstractSelectCondition<C>>
extends AbstractSortableCondition<C>
implements SelectCondition<C, HavingConditionBuilderImpl> {
    private final List<ConditionItem> conditionItems = new ArrayList<ConditionItem>();
    private final List<OrderItem> orderItems = new ArrayList<OrderItem>();
    private GroupByItem groupByItem;
    private HavingConditionBuilderImpl havingConditionBuilder;
    private LimitItem limitItem;
    private OffsetItem offsetItem;

    @Override
    public C groupBy(String ... fields) {
        this.groupByItem = new StandardGroupBy(Arrays.asList(fields));
        return (C)((AbstractSelectCondition)this.childThis);
    }

    @Override
    public C groupBy(Enum<?> ... fields) {
        return (C)this.groupBy(Arrays.stream(fields).map(this::resolveFieldName).toList());
    }

    @Override
    public C groupBy(Collection<String> fields) {
        this.groupByItem = new StandardGroupBy(fields);
        return (C)((AbstractSelectCondition)this.childThis);
    }

    @Override
    public C groupByEnum(Collection<Enum<?>> fields) {
        return (C)this.groupBy(fields.stream().map(this::resolveFieldName).toList());
    }

    @Override
    public SelectCondition.HavingConditionBuilder<HavingConditionBuilderImpl, C> having() {
        this.havingConditionBuilder = new HavingConditionBuilderImpl();
        return this.havingConditionBuilder;
    }

    @Override
    public C offset(long number) {
        this.offsetItem = new StandardOffsetItem(number);
        return (C)((AbstractSelectCondition)this.childThis);
    }

    @Override
    protected void addConditionItem(ConditionItem conditionItem) {
        this.conditionItems.add(conditionItem);
    }

    @Override
    protected void addOrderItem(OrderItem orderItem) {
        this.orderItems.add(orderItem);
    }

    @Override
    protected void setLimitItem(LimitItem limitItem) {
        this.limitItem = limitItem;
    }

    @Override
    protected void beforeBuild() {
        if (!this.conditionItems.isEmpty()) {
            this.addSqlFragment(new TokenSqlFragment(StrFormatter.format((String)"WHERE {}", (Object[])new Object[]{ConditionItem.stripHeaderKeywordStatic(this.conditionItems.stream().map(SqlFragment::buildSqlFragment).collect(Collectors.joining(" ")))})));
        }
        if (this.groupByItem != null) {
            this.addSqlFragment(this.groupByItem);
        }
        if (this.havingConditionBuilder != null) {
            this.addSqlFragment(this.havingConditionBuilder);
        }
        if (!this.orderItems.isEmpty()) {
            this.addSqlFragment(new CompositeOrderItem(this.orderItems));
        }
        if (this.limitItem != null) {
            this.addSqlFragment(this.limitItem);
        }
        if (this.offsetItem != null) {
            this.addSqlFragment(this.offsetItem);
        }
    }

    public class HavingConditionBuilderImpl
    extends AbstractCondition<HavingConditionBuilderImpl>
    implements SelectCondition.HavingConditionBuilder<HavingConditionBuilderImpl, C> {
        private final List<ConditionItem> conditionItems = new ArrayList<ConditionItem>();

        @Override
        public SqlParameterManager getSqlParameterManager() {
            return AbstractSelectCondition.this.getSqlParameterManager();
        }

        @Override
        protected void addConditionItem(ConditionItem conditionItem) {
            this.conditionItems.add(conditionItem);
        }

        @Override
        public String buildSqlFragment() {
            return StrFormatter.format((String)"HAVING {}", (Object[])new Object[]{ConditionItem.stripHeaderKeywordStatic(this.conditionItems.stream().map(SqlFragment::buildSqlFragment).collect(Collectors.joining(", ")))});
        }

        @Override
        public C end() {
            return (AbstractSelectCondition)AbstractSelectCondition.this.childThis;
        }

        @Override
        public TableAliasManager getTableAliasManager() {
            return AbstractSelectCondition.this.getTableAliasManager();
        }
    }
}

