/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.abs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.core.text.StrUtils;
import org.elsfs.tool.sql.abs.AbstractCondition;
import org.elsfs.tool.sql.abs.AbstractSelectJoin;
import org.elsfs.tool.sql.abs.CompositeSqlFragment;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.common.FieldEnumResolverSupport;
import org.elsfs.tool.sql.common.HierarchyTableAliasManager;
import org.elsfs.tool.sql.common.SimpleTableAliasManager;
import org.elsfs.tool.sql.condition.ConditionItem;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.interfaces.Join;
import org.elsfs.tool.sql.interfaces.JoinType;
import org.elsfs.tool.sql.interfaces.SqlFragment;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;
import org.elsfs.tool.sql.interfaces.SqlParameterManagerAware;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.interfaces.TableAliasManagerAware;
import org.elsfs.tool.sql.interfaces.TokenSqlFragment;
import org.elsfs.tool.sql.select.ExpressionSelectItem;
import org.elsfs.tool.sql.select.SelectItem;
import org.elsfs.tool.sql.select.StandardSelectItem;
import org.elsfs.tool.sql.select.SubQuerySelectItem;
import org.elsfs.tool.sql.utils.CastUtils;

public abstract class AbstractSelectJoin<C extends AbstractSelectJoin<C>>
extends CompositeSqlFragment
implements Join<C, SelectJoinBuilderImpl, JoinConditionBuilderImpl>,
SqlParameterManagerAware,
TableAliasManagerAware {
    protected final C childThis = (AbstractSelectJoin)CastUtils.cast(this);
    private final List<SelectJoinBuilderImpl> joinBuilders = new ArrayList<SelectJoinBuilderImpl>();

    protected abstract String getTableName(Class<?> var1);

    @Override
    public SelectJoinBuilderImpl join(Class<?> entityClass) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.INNER_JOIN, this.getTableName(entityClass));
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl join(Class<?> entityClass, String tableAlias, boolean registerAlias) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.INNER_JOIN, this.getTableName(entityClass), tableAlias, registerAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl join(Class<?> entityClass, String tableAlias) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.INNER_JOIN, this.getTableName(entityClass), tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl join(String table) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.INNER_JOIN, table);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl join(String table, String tableAlias) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.INNER_JOIN, table, tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl join(String table, String tableAlias, boolean registerAlias) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.INNER_JOIN, table, tableAlias, registerAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl join(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias) {
        return this.doSubQueryJoin(sqlBuilderConsumer, tableAlias, JoinType.INNER_JOIN);
    }

    @Override
    public SelectJoinBuilderImpl leftJoin(Class<?> entityClass) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.LEFT_JOIN, this.getTableName(entityClass));
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl leftJoin(Class<?> entityClass, String tableAlias) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.LEFT_JOIN, this.getTableName(entityClass), tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl leftJoin(Class<?> entityClass, String tableAlias, boolean registerAlias) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.LEFT_JOIN, this.getTableName(entityClass), tableAlias, registerAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl leftJoin(String table) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.LEFT_JOIN, table);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl leftJoin(String table, String tableAlias) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.LEFT_JOIN, table, tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl leftJoin(String table, String tableAlias, boolean registerAlias) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.LEFT_JOIN, table, tableAlias, registerAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl leftJoin(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias) {
        return this.doSubQueryJoin(sqlBuilderConsumer, tableAlias, JoinType.LEFT_JOIN);
    }

    @Override
    public SelectJoinBuilderImpl rightJoin(Class<?> entityClass) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.RIGHT_JOIN, this.getTableName(entityClass));
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl rightJoin(Class<?> entityClass, String tableAlias) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.RIGHT_JOIN, this.getTableName(entityClass), tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl rightJoin(Class<?> entityClass, String tableAlias, boolean registerAlias) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.RIGHT_JOIN, this.getTableName(entityClass), tableAlias, registerAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl rightJoin(String table) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.RIGHT_JOIN, table);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl rightJoin(String table, String tableAlias) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.RIGHT_JOIN, table, tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl rightJoin(String table, String tableAlias, boolean registerAlias) {
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(JoinType.RIGHT_JOIN, table, tableAlias, registerAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public SelectJoinBuilderImpl rightJoin(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias) {
        return this.doSubQueryJoin(sqlBuilderConsumer, tableAlias, JoinType.RIGHT_JOIN);
    }

    private SelectJoinBuilderImpl doSubQueryJoin(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias, JoinType joinType) {
        if (StrUtils.isBlank((String)tableAlias)) {
            throw new SqlBuilderException("JOIN\u5b50\u67e5\u8be2\u7684\u8868\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StandardSelectSql standardSelectSql = new StandardSelectSql(this.getSqlParameterManager(), new HierarchyTableAliasManager(new SimpleTableAliasManager(), this.getTableAliasManager()));
        sqlBuilderConsumer.accept(standardSelectSql);
        SelectJoinBuilderImpl joinBuilder = new SelectJoinBuilderImpl(joinType, "(" + standardSelectSql.buildSqlFragment() + ")", tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    protected void beforeBuild() {
        for (SelectJoinBuilderImpl joinBuilder : this.joinBuilders) {
            this.addSqlFragment(joinBuilder);
        }
    }

    protected abstract void addSelectItem(SelectItem var1);

    public class SelectJoinBuilderImpl
    extends CompositeSqlFragment
    implements Join.SelectJoinBuilder<SelectJoinBuilderImpl, org.elsfs.tool.sql.abs.AbstractSelectJoin$SelectJoinBuilderImpl.JoinConditionBuilderImpl, C>,
    SqlParameterManagerAware,
    TableAliasManagerAware {
        private final JoinType joinType;
        private final String table;
        private final String tableAlias;
        private org.elsfs.tool.sql.abs.AbstractSelectJoin$SelectJoinBuilderImpl.JoinConditionBuilderImpl joinConditionBuilder;

        public SelectJoinBuilderImpl(JoinType joinType, String table, String tableAlias, boolean registerAlias) {
            this.joinType = joinType;
            this.table = table;
            this.tableAlias = tableAlias;
            if (registerAlias) {
                AbstractSelectJoin.this.getTableAliasManager().registerAlias(table, tableAlias);
            }
        }

        public SelectJoinBuilderImpl(JoinType joinType, String table, String tableAlias) {
            this(joinType, table, tableAlias, true);
        }

        public SelectJoinBuilderImpl(JoinType joinType, String table) {
            this(joinType, table, this$0.getTableAliasManager().generateAlias(table), true);
        }

        protected String resolveFieldName(Enum<?> field) {
            return FieldEnumResolverSupport.resolveFieldName(this.getTableAliasManager(), field);
        }

        @Override
        public C end() {
            return AbstractSelectJoin.this.childThis;
        }

        @Override
        public org.elsfs.tool.sql.abs.AbstractSelectJoin$SelectJoinBuilderImpl.JoinConditionBuilderImpl on() {
            this.joinConditionBuilder = new JoinConditionBuilderImpl();
            return this.joinConditionBuilder;
        }

        @Override
        protected void beforeBuild() {
            this.addSqlFragment(new TokenSqlFragment(this.joinType.getJoinKeyword()));
            this.addSqlFragment(new TokenSqlFragment(this.table + " AS " + this.tableAlias));
            this.addSqlFragment((SqlFragment)this.joinConditionBuilder);
        }

        @Override
        public SqlParameterManager getSqlParameterManager() {
            return AbstractSelectJoin.this.getSqlParameterManager();
        }

        @Override
        public SelectJoinBuilderImpl select(String ... fields) {
            for (String field : fields) {
                this.addSelectField(field);
            }
            return this;
        }

        @Override
        public SelectJoinBuilderImpl select(Enum<?> ... fields) {
            for (Enum<?> field : fields) {
                this.addSelectField(this.resolveFieldName(field));
            }
            return this;
        }

        @Override
        public SelectJoinBuilderImpl select(Collection<String> fields) {
            for (String field : fields) {
                this.addSelectField(field);
            }
            return this;
        }

        @Override
        public SelectJoinBuilderImpl selectExpression(String ... expressions) {
            for (String expression : expressions) {
                this.addSelectExpression(expression);
            }
            return this;
        }

        @Override
        public SelectJoinBuilderImpl selectExpression(Collection<String> expressions) {
            for (String expression : expressions) {
                this.addSelectExpression(expression);
            }
            return this;
        }

        @Override
        public SelectJoinBuilderImpl selectAs(String field, String fieldAlias) {
            if (StrUtils.isBlank((String)fieldAlias)) {
                throw new SqlBuilderException("\u9009\u62e9\u5b57\u6bb5[{}]\u7684\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a" + field);
            }
            this.addSelectField(field + " AS " + fieldAlias);
            return this;
        }

        @Override
        public SelectJoinBuilderImpl selectAs(Enum<?> field, String fieldAlias) {
            return this.selectAs(this.resolveFieldName(field), fieldAlias);
        }

        @Override
        public SelectJoinBuilderImpl selectAs(Enum<?> field, Enum<?> fieldAlias) {
            return this.selectAs((Enum)field, fieldAlias.name());
        }

        @Override
        public SelectJoinBuilderImpl selectAs(Consumer<StandardSelectSql> sqlBuilderConsumer, String fieldAlias) {
            if (StrUtils.isBlank((String)fieldAlias)) {
                throw new SqlBuilderException("\u9009\u62e9\u5b50\u67e5\u8be2\u7684\u5b57\u6bb5\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            StandardSelectSql standardSelectSql = new StandardSelectSql(this.getSqlParameterManager(), new HierarchyTableAliasManager(new SimpleTableAliasManager(), this.getTableAliasManager()));
            sqlBuilderConsumer.accept(standardSelectSql);
            this.addSelectSubQuery(standardSelectSql, fieldAlias);
            return this;
        }

        @Override
        public SelectJoinBuilderImpl selectAs(Consumer<StandardSelectSql> sqlBuilderConsumer, Enum<?> fieldAlias) {
            return this.selectAs((Consumer)sqlBuilderConsumer, fieldAlias.name());
        }

        private void addSelectField(String field) {
            StandardSelectItem selectItem = new StandardSelectItem(field);
            if (StrUtils.isBlank((String)selectItem.getTableAlias())) {
                selectItem = new StandardSelectItem(this.tableAlias, selectItem.getField(), selectItem.getFieldAlias());
            }
            AbstractSelectJoin.this.addSelectItem(selectItem);
        }

        private void addSelectSubQuery(StandardSelectSql selectSql, String fieldAlias) {
            AbstractSelectJoin.this.addSelectItem(new SubQuerySelectItem(selectSql.buildSqlFragment(), fieldAlias));
        }

        private void addSelectExpression(String expression) {
            AbstractSelectJoin.this.addSelectItem(new ExpressionSelectItem(expression));
        }

        @Override
        public SelectJoinBuilderImpl selectEnum(Collection<Enum<?>> fields) {
            for (Enum<?> field : fields) {
                this.addSelectField(this.resolveFieldName(field));
            }
            return this;
        }

        @Override
        public TableAliasManager getTableAliasManager() {
            return AbstractSelectJoin.this.getTableAliasManager();
        }

        public class JoinConditionBuilderImpl
        extends AbstractCondition<org.elsfs.tool.sql.abs.AbstractSelectJoin$SelectJoinBuilderImpl.JoinConditionBuilderImpl>
        implements Join.JoinConditionBuilder<org.elsfs.tool.sql.abs.AbstractSelectJoin$SelectJoinBuilderImpl.JoinConditionBuilderImpl, SelectJoinBuilderImpl, C> {
            private final List<ConditionItem> conditionItems = new ArrayList<ConditionItem>();

            @Override
            public SqlParameterManager getSqlParameterManager() {
                return SelectJoinBuilderImpl.this.getSqlParameterManager();
            }

            @Override
            protected void addConditionItem(ConditionItem conditionItem) {
                this.conditionItems.add(conditionItem);
            }

            @Override
            public C end() {
                return SelectJoinBuilderImpl.this.end();
            }

            @Override
            public String buildSqlFragment() {
                if (this.conditionItems.isEmpty()) {
                    return "";
                }
                return StrFormatter.format((String)"ON {}", (Object[])new Object[]{ConditionItem.stripHeaderKeywordStatic(this.conditionItems.stream().map(SqlFragment::buildSqlFragment).collect(Collectors.joining(" ")))});
            }

            @Override
            public TableAliasManager getTableAliasManager() {
                return SelectJoinBuilderImpl.this.getTableAliasManager();
            }
        }
    }
}

