/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.insert;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.insert.ValuesItem;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

public class StandardValuesItem
implements ValuesItem {
    protected final SqlParameterManager sqlParameterManager;
    private final Collection<String> insertFields;
    private final Collection<Map<String, Object>> values;

    public StandardValuesItem(SqlParameterManager sqlParameterManager, Collection<String> insertFields, Collection<Map<String, Object>> values) {
        this.sqlParameterManager = sqlParameterManager;
        this.insertFields = insertFields;
        this.values = values;
    }

    @Override
    public String buildSqlFragment() {
        if (this.values.isEmpty()) {
            return "VALUES";
        }
        return StrFormatter.format((String)"VALUES {}", (Object[])new Object[]{this.values.stream().map(value -> StrFormatter.format((String)"({})", (Object[])new Object[]{this.insertFields.stream().map(field -> {
            Object v = value.get(field);
            if (v == null) {
                return "NULL";
            }
            return SqlParameterManager.buildParameterPlaceholder(this.sqlParameterManager.registerParameter(v));
        }).collect(Collectors.joining(", "))})).collect(Collectors.joining(", "))});
    }
}

