/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.select;

import java.util.regex.Pattern;
import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrUtils;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.select.SelectItem;

public class ExpressionSelectItem
implements SelectItem {
    private static final Pattern FIELD_ALIAS_SPLITTING_PATTERN = Pattern.compile("( +as +(?=\\w+$))|( +(?=\\w+$))", 2);
    private final String expression;
    private final String fieldAlias;

    public String getExpression() {
        return this.expression;
    }

    public String getFieldAlias() {
        return this.fieldAlias;
    }

    public ExpressionSelectItem(String expression) {
        if (StrUtils.isBlank((String)expression)) {
            throw new SqlBuilderException("\u9009\u62e9\u5b57\u6bb5\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] tokens = FIELD_ALIAS_SPLITTING_PATTERN.split(expression);
        if (tokens.length == 0) {
            throw new SqlBuilderException("\u9009\u62e9\u5b57\u6bb5\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (tokens.length == 1) {
            this.expression = tokens[0];
            this.fieldAlias = null;
            return;
        }
        this.expression = tokens[0];
        this.fieldAlias = tokens[1];
    }

    @Override
    public String buildSqlFragment() {
        StringBuilder stringBuilder = new StringBuilder();
        if (StrUtils.isBlank((String)this.fieldAlias)) {
            stringBuilder.append(NamingCase.toUnderlineCase((CharSequence)this.expression));
        } else {
            stringBuilder.append(NamingCase.toUnderlineCase((CharSequence)this.expression)).append(" AS ").append(NamingCase.toUnderlineCase((CharSequence)this.fieldAlias));
        }
        return stringBuilder.toString();
    }
}

