/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.singular.facade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EntityRelationDescriptor {
    private final Class<?> entityClass;
    private final String foreignKeyField;
    private final String joinKeyField;
    private final List<String> selectionFields;

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getForeignKeyField() {
        return this.foreignKeyField;
    }

    public String getJoinKeyField() {
        return this.joinKeyField;
    }

    public List<String> getSelectionFields() {
        return this.selectionFields;
    }

    public EntityRelationDescriptor(Class<?> entityClass, String foreignKeyField, String joinKeyField, List<String> selectionFields) {
        this.entityClass = entityClass;
        this.foreignKeyField = foreignKeyField;
        this.joinKeyField = joinKeyField;
        this.selectionFields = selectionFields;
    }

    public static EntityRelationDescriptor create(Class<?> entityClass, String foreignKeyField, String ... selectionFields) {
        return new EntityRelationDescriptor(entityClass, foreignKeyField, null, Arrays.asList(selectionFields));
    }

    public static EntityRelationDescriptor create(Class<?> entityClass, Enum<?> foreignKeyField, String ... selectionFields) {
        return new EntityRelationDescriptor(entityClass, foreignKeyField.name(), null, Arrays.asList(selectionFields));
    }

    public static EntityRelationDescriptorBuilder builder(Class<?> entityClass, String foreignKeyField) {
        return new EntityRelationDescriptorBuilder(entityClass, foreignKeyField);
    }

    public static EntityRelationDescriptorBuilder builder(Class<?> entityClass, Enum<?> foreignKeyField) {
        return new EntityRelationDescriptorBuilder(entityClass, foreignKeyField.name());
    }

    public static class EntityRelationDescriptorBuilder {
        private final Class<?> entityClass;
        private final String foreignKeyField;
        private final List<String> selectionFields = new ArrayList<String>();
        private String joinKeyField;

        public EntityRelationDescriptorBuilder(Class<?> entityClass, String foreignKeyField) {
            this.entityClass = entityClass;
            this.foreignKeyField = foreignKeyField;
        }

        public EntityRelationDescriptorBuilder joinKeyField(String field) {
            this.joinKeyField = field;
            return this;
        }

        public EntityRelationDescriptorBuilder joinKeyField(Enum<?> field) {
            this.joinKeyField = field.name();
            return this;
        }

        public EntityRelationDescriptorBuilder select(String field) {
            this.selectionFields.add(field);
            return this;
        }

        public EntityRelationDescriptorBuilder select(Enum<?> field) {
            this.selectionFields.add(field.name());
            return this;
        }

        public EntityRelationDescriptorBuilder selectAs(String field, String alias) {
            this.selectionFields.add(field + " AS " + alias);
            return this;
        }

        public EntityRelationDescriptorBuilder selectAs(Enum<?> field, Enum<?> alias) {
            this.selectionFields.add(field.name() + " AS " + alias.name());
            return this;
        }

        public EntityRelationDescriptorBuilder selectAs(Enum<?> field, String alias) {
            this.selectionFields.add(field.name() + " AS " + alias);
            return this;
        }

        public EntityRelationDescriptorBuilder selectAs(String field, Enum<?> alias) {
            this.selectionFields.add(field + " AS " + alias.name());
            return this;
        }

        public EntityRelationDescriptor build() {
            return new EntityRelationDescriptor(this.entityClass, this.foreignKeyField, this.joinKeyField, this.selectionFields);
        }
    }
}

