/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.conditional.XorExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import org.elsfs.tool.core.text.ArrayUtils;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.core.text.StrUtils;
import org.elsfs.tool.core.util.DateTimeUtils;
import org.elsfs.tool.sql.exception.SqlBuilderException;

public final class SqlUtils {
    public static String handleSqlParameterValue(Object value) {
        if (value instanceof CharSequence) {
            return "'" + value + "'";
        }
        if (value instanceof Enum) {
            Enum enumeration = (Enum)value;
            return "'" + enumeration.name() + "'";
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return "'" + DateTimeUtils.toLocalDateTime((Date)date) + "'";
        }
        if (value instanceof LocalDateTime || value instanceof LocalDate || value instanceof LocalTime) {
            return "'" + value + "'";
        }
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }

    public static String handleSqlExpression(String sqlExpression, Object ... args) {
        if (StrUtils.isBlank((String)sqlExpression) || ArrayUtils.isEmpty((Object[])args)) {
            return sqlExpression;
        }
        Object[] processedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            processedArgs[i] = SqlUtils.handleSqlParameterValue(args[i]);
        }
        return StrFormatter.format((String)sqlExpression, (Object[])processedArgs);
    }

    public static Set<String> parseConditionSqlColumnNames(String conditionSql) {
        return SqlUtils.parseConditionSqlColumns(conditionSql).stream().map(Column::getFullyQualifiedName).collect(Collectors.toSet());
    }

    public static Set<Column> parseConditionSqlColumns(String conditionSql) {
        try {
            Expression expression = CCJSqlParserUtil.parseCondExpression((String)conditionSql);
            WhereConditionExpressionVisitor expressionVisitor = new WhereConditionExpressionVisitor();
            expression.accept((ExpressionVisitor)expressionVisitor);
            return expressionVisitor.columns;
        }
        catch (JSQLParserException e) {
            throw new SqlBuilderException("\u89e3\u6790\u6761\u4ef6SQL\u6761\u4ef6\u5217\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    static class WhereConditionExpressionVisitor
    extends ExpressionVisitorAdapter {
        private final Set<Column> columns = new HashSet<Column>();

        WhereConditionExpressionVisitor() {
        }

        public void visit(Function function) {
            ExpressionList parameters = function.getParameters();
            if (parameters == null) {
                return;
            }
            for (Expression expression : parameters.getExpressions()) {
                expression.accept((ExpressionVisitor)this);
            }
        }

        public void visit(Parenthesis parenthesis) {
            parenthesis.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(AndExpression expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
            expr.getRightExpression().accept((ExpressionVisitor)this);
        }

        public void visit(OrExpression expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
            expr.getRightExpression().accept((ExpressionVisitor)this);
        }

        public void visit(XorExpression expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
            expr.getRightExpression().accept((ExpressionVisitor)this);
        }

        public void visit(Between expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
            expr.getBetweenExpressionStart().accept((ExpressionVisitor)this);
            expr.getBetweenExpressionEnd().accept((ExpressionVisitor)this);
        }

        public void visit(EqualsTo expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
            expr.getRightExpression().accept((ExpressionVisitor)this);
        }

        public void visit(GreaterThan expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
            expr.getRightExpression().accept((ExpressionVisitor)this);
        }

        public void visit(GreaterThanEquals expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
            expr.getRightExpression().accept((ExpressionVisitor)this);
        }

        public void visit(InExpression expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
            if (expr.getRightItemsList() != null) {
                expr.getRightItemsList().accept((ItemsListVisitor)this);
            } else if (expr.getRightExpression() != null) {
                expr.getRightExpression().accept((ExpressionVisitor)this);
            }
        }

        public void visit(IsNullExpression expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
        }

        public void visit(LikeExpression expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
            expr.getRightExpression().accept((ExpressionVisitor)this);
        }

        public void visit(MinorThan expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
            expr.getRightExpression().accept((ExpressionVisitor)this);
        }

        public void visit(MinorThanEquals expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
            expr.getRightExpression().accept((ExpressionVisitor)this);
        }

        public void visit(NotEqualsTo expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
            expr.getRightExpression().accept((ExpressionVisitor)this);
        }

        public void visit(Column column) {
            this.columns.add(column);
        }

        public void visit(CastExpression expr) {
            expr.getLeftExpression().accept((ExpressionVisitor)this);
        }

        public void visit(NotExpression notExpr) {
            notExpr.getExpression().accept((ExpressionVisitor)this);
        }

        public void visit(SignedExpression expr) {
            expr.getExpression().accept((ExpressionVisitor)this);
        }
    }
}

