package org.elsfs.tool.sql.abs;

import java.util.ArrayList;
import java.util.List;
import org.elsfs.tool.sql.condition.ConditionItem;
import org.elsfs.tool.sql.interfaces.Condition;
import org.elsfs.tool.sql.interfaces.NestCondition;

/**
 * 抽象嵌套条件实现
 *
 * @param <P> 上级对象类型
 * @author zeng
 * @since 0.0.4
 */
public abstract class AbstractNestCondition<P extends Condition<P>>
    extends AbstractCondition<AbstractNestCondition<P>>
    implements NestCondition<AbstractNestCondition<P>, P> {

  /** 条件项列表 */
  private final List<ConditionItem> conditionItems = new ArrayList<>();

  public List<ConditionItem> getConditionItems() {
    return conditionItems;
  }

  /**
   * 添加一个条件
   *
   * @param conditionItem 条件
   */
  @Override
  protected void addConditionItem(ConditionItem conditionItem) {
    this.conditionItems.add(conditionItem);
  }
}
