package org.elsfs.tool.sql.common;

import org.elsfs.tool.core.text.StrUtils;
import org.elsfs.tool.sql.interfaces.TableAliasManager;

/**
 * 层级表别名管理器
 *
 * @author zeng
 * @version 0.0.4
 */
public class HierarchyTableAliasManager implements TableAliasManager {

  /** 代理表别名管理器 */
  private final TableAliasManager delegate;

  /** 父级表别名管理器 */
  private final TableAliasManager parent;

  public HierarchyTableAliasManager(TableAliasManager delegate, TableAliasManager parent) {
    this.delegate = delegate;
    this.parent = parent;
  }

  /**
   * 生成表别名
   *
   * @param entityClass 表实体类
   * @return 别名
   */
  @Override
  public String generateAlias(Class<?> entityClass) {
    return this.delegate.generateAlias(entityClass);
  }

  /**
   * 生成表别名
   *
   * @param table 数据库表名
   * @return 别名
   */
  @Override
  public String generateAlias(String table) {
    return this.delegate.generateAlias(table);
  }

  /**
   * 注册表别名
   *
   * @param entityClass 表实体类
   * @param alias 别名
   */
  @Override
  public void registerAlias(Class<?> entityClass, String alias) {
    this.delegate.registerAlias(entityClass, alias);
  }

  /**
   * 注册表别名
   *
   * @param table 数据库表名
   * @param alias 别名
   */
  @Override
  public void registerAlias(String table, String alias) {
    this.delegate.registerAlias(table, alias);
  }

  /**
   * 获取表别名
   *
   * @param entityClass 表实体类
   * @return 表别名
   */
  @Override
  public String fetchTableAlias(Class<?> entityClass) {
    String alias = this.delegate.fetchTableAlias(entityClass);
    if (StrUtils.isBlank(alias)) {
      alias = this.parent.fetchTableAlias(entityClass);
    }

    return alias;
  }

  /**
   * 获取表别名
   *
   * @param table 数据库表名
   * @return 表别名
   */
  @Override
  public String fetchTableAlias(String table) {
    String alias = this.delegate.fetchTableAlias(table);
    if (StrUtils.isBlank(alias)) {
      alias = this.parent.fetchTableAlias(table);
    }

    return alias;
  }
}
