package org.elsfs.tool.sql.common;

import java.util.HashMap;
import java.util.Map;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 简单的SQL参数管理器
 *
 * @author zeng
 * @version 0.0.4
 */
public class SimpleSqlParameterManager implements SqlParameterManager {

  /** 参数名称前缀 */
  private static final String PARAMETER_NAME_PREFIX = "sqlParameter";

  /** SQL参数 */
  private final Map<String, Object> parameters = new HashMap<>();

  /** 参数索引 */
  private int parameterIndex;

  /**
   * 注册SQL参数
   *
   * @param value 参数值
   * @return 参数名称
   */
  @Override
  public String registerParameter(Object value) {
    String parameterName = PARAMETER_NAME_PREFIX + this.parameterIndex++;
    this.parameters.put(parameterName, value);
    return parameterName;
  }

  /**
   * 获取SQL参数
   *
   * @return SQL参数
   */
  @Override
  public Map<String, Object> getSqlParameters() {
    return this.parameters;
  }
}
