package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 区间开始值条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class BetweenBeginValueConditionItem implements ConditionItem {

  /** SQL参数管理器 */
  protected final SqlParameterManager sqlParameterManager;

  /** 左边字段名称 */
  protected final String leftField;

  /** 区间开始值 */
  protected final Object beginValue;

  /** 区间结束字段名称 */
  protected final String endField;

  /**
   * 构造函数
   *
   * @param sqlParameterManager SQL参数管理器
   * @param leftField 左边字段名称
   * @param beginValue 区间开始值
   * @param endField 区间结束字段名称
   */
  public BetweenBeginValueConditionItem(
      SqlParameterManager sqlParameterManager,
      String leftField,
      Object beginValue,
      String endField) {
    this.sqlParameterManager = sqlParameterManager;
    this.leftField = leftField;
    this.beginValue = beginValue;
    this.endField = endField;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} BETWEEN {} AND {}",
        NamingCase.toUnderlineCase(this.leftField),
        SqlParameterManager.buildParameterPlaceholder(
            this.sqlParameterManager.registerParameter(this.beginValue)),
        NamingCase.toUnderlineCase(this.endField));
  }
}
