package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;

/**
 * 字段区间条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class BetweenFieldConditionItem implements ConditionItem {

  /** 左边字段名称 */
  protected final String leftField;

  /** 区间开始字段名称 */
  protected final String beginField;

  /** 区间结束字段名称 */
  protected final String endField;

  /**
   * 构造函数
   *
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endField 区间结束字段名称
   */
  public BetweenFieldConditionItem(String leftField, String beginField, String endField) {
    this.leftField = leftField;
    this.beginField = beginField;
    this.endField = endField;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} BETWEEN {} AND {}",
        NamingCase.toUnderlineCase(this.leftField),
        NamingCase.toUnderlineCase(this.beginField),
        NamingCase.toUnderlineCase(this.endField));
  }
}
