package org.elsfs.tool.sql.condition;

import java.util.List;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 聚合条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class CompositeConditionItem implements ConditionItem {

  /** 条件列表 */
  private final List<ConditionItem> conditions;

  public CompositeConditionItem(List<ConditionItem> conditions) {
    this.conditions = conditions;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    if (this.conditions.isEmpty()) {
      return SqlPool.EMPTY;
    }

    String conditionSql =
        this.conditions.stream()
            .map(ConditionItem::buildSqlFragment)
            .collect(Collectors.joining(SqlPool.SPACE));

    if (this.conditions.size() == 1) {
      return stripHeaderKeyword(conditionSql);
    }

    return StrFormatter.format("({})", stripHeaderKeyword(conditionSql));
  }
}
