package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 字段值条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class FieldValueConditionItem implements ConditionItem {

  /** SQL参数管理器 */
  private final SqlParameterManager sqlParameterManager;

  /** 左边字段名称 */
  private final String leftField;

  /** 右边字面量值 */
  private final Object rightValue;

  /** 条件操作符 */
  private final CompareOperator compareOperator;

  /**
   * 构造函数
   *
   * @param sqlParameterManager SQL参数管理器
   * @param leftField 左边字段名称
   * @param rightValue 右边字面量值
   * @param compareOperator 条件操作符
   */
  public FieldValueConditionItem(
      SqlParameterManager sqlParameterManager,
      String leftField,
      Object rightValue,
      CompareOperator compareOperator) {
    this.sqlParameterManager = sqlParameterManager;
    this.leftField = leftField;
    this.rightValue = rightValue;
    this.compareOperator = compareOperator;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return NamingCase.toUnderlineCase(this.leftField)
        + this.compareOperator.getOperator()
        + SqlParameterManager.buildParameterPlaceholder(
            this.sqlParameterManager.registerParameter(this.rightValue));
  }
}
