package org.elsfs.tool.sql.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 范围条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class InConditionItem implements ConditionItem {

  /** SQL参数管理器 */
  protected final SqlParameterManager sqlParameterManager;

  /** 左边字段名称 */
  protected final String leftField;

  /** 范围字段 */
  protected final Collection<String> inFields;

  /** 范围值 */
  protected final Collection<?> inValues;

  /**
   * 构建新的'比较'条件
   *
   * @param sqlParameterManager SQL参数管理器
   * @param leftField 左边字段名称
   * @param inFields 范围字段
   * @param inValues 范围值
   */
  public InConditionItem(
      SqlParameterManager sqlParameterManager,
      String leftField,
      Collection<String> inFields,
      Collection<?> inValues) {
    this.sqlParameterManager = sqlParameterManager;
    this.leftField = leftField;
    this.inFields = inFields;
    this.inValues = inValues;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    List<String> tokens = new ArrayList<>();

    if (this.inFields != null) {
      for (String inField : this.inFields) {
        tokens.add(NamingCase.toUnderlineCase(inField));
      }
    }
    if (this.inValues != null) {
      for (Object inValue : this.inValues) {
        tokens.add(
            SqlParameterManager.buildParameterPlaceholder(
                this.sqlParameterManager.registerParameter(inValue)));
      }
    }

    return this.buildSqlFragment(String.join(SqlPool.COMMA_WITH_SPACE, tokens));
  }

  /**
   * 构建SQL片段
   *
   * @param token IN部分SQL
   * @return SQL片段
   */
  protected String buildSqlFragment(String token) {
    return StrFormatter.format("{} IN ({})", NamingCase.toUnderlineCase(this.leftField), token);
  }
}
