package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 模糊匹配条件项
 *
 * @author zeng
 * @version 0.0.4
 */
public class LikeConditionItem implements ConditionItem {

  /** SQL参数管理器 */
  protected final SqlParameterManager sqlParameterManager;

  /** 模糊匹配类型 */
  protected final LikeType likeType;

  /** 左边字段名称 */
  protected final String leftField;

  /** 模糊匹配值 */
  protected final String likeValue;

  /**
   * 构造函数
   *
   * @param sqlParameterManager SQL参数管理器
   * @param likeType 模糊匹配类型
   * @param leftField 左边字段名称
   * @param likeValue 模糊匹配值
   */
  public LikeConditionItem(
      SqlParameterManager sqlParameterManager,
      LikeType likeType,
      String leftField,
      String likeValue) {
    this.sqlParameterManager = sqlParameterManager;
    this.likeType = likeType;
    this.leftField = leftField;
    this.likeValue = likeValue;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} LIKE {}",
        NamingCase.toUnderlineCase(this.leftField),
        SqlParameterManager.buildParameterPlaceholder(
            this.sqlParameterManager.registerParameter(
                StrFormatter.format(this.likeType.getTemplate(), this.likeValue))));
  }
}
