package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;

/**
 * 不在字段区间条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class NotBetweenFieldConditionItem extends BetweenFieldConditionItem {

  public NotBetweenFieldConditionItem(String leftField, String beginField, String endField) {
    super(leftField, beginField, endField);
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} NOT BETWEEN {} AND {}",
        NamingCase.toUnderlineCase(this.leftField),
        NamingCase.toUnderlineCase(this.beginField),
        NamingCase.toUnderlineCase(this.endField));
  }
}
