package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;

/**
 * 子查询排除范围条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class NotInSubQueryConditionItem extends InSubQueryConditionItem {

  public NotInSubQueryConditionItem(String leftField, String inSql) {
    super(leftField, inSql);
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} NOT IN ({})", NamingCase.toUnderlineCase(this.leftField), this.inSql);
  }
}
