package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 非模糊匹配条件项
 *
 * @author zeng
 * @version 0.0.4
 */
public class NotLikeConditionItem extends LikeConditionItem {

  public NotLikeConditionItem(
      SqlParameterManager sqlParameterManager,
      LikeType likeType,
      String leftField,
      String likeValue) {
    super(sqlParameterManager, likeType, leftField, likeValue);
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} NOT LIKE {}",
        NamingCase.toUnderlineCase(this.leftField),
        SqlParameterManager.buildParameterPlaceholder(
            this.sqlParameterManager.registerParameter(
                StrFormatter.format(this.likeType.getTemplate(), this.likeValue))));
  }
}
