package org.elsfs.tool.sql.executor;

import org.elsfs.tool.sql.builder.GenericDeleteSql;
import org.elsfs.tool.sql.interfaces.SqlExecutor;

/**
 * 删除SQL执行器
 *
 * @author zeng
 * @version 0.0.4
 */
public class DeleteSqlExecutor extends GenericDeleteSql<DeleteSqlExecutor>
    implements SqlExecutor<Integer> {

  /** 通用SQL执行器 */
  private final GenericSqlExecutor genericSqlExecutor;

  public DeleteSqlExecutor(GenericSqlExecutor genericSqlExecutor) {
    this.genericSqlExecutor = genericSqlExecutor;
  }

  /**
   * 执行SQL
   *
   * @return 结果
   */
  @Override
  public Integer execute() {
    return this.genericSqlExecutor.delete(
        this.buildSqlFragment(), this.getSqlParameterManager().getSqlParameters());
  }

  @Override
  protected String getTableName(Class<?> entityClass) {
    // Todo
    return null;
  }
}
