package org.elsfs.tool.sql.executor;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elsfs.tool.core.page.IPage;
import org.elsfs.tool.core.page.Page;

/**
 * SQL执行器
 *
 * @author zeng
 * @version 0.0.4
 */
public interface GenericSqlExecutor {

  /**
   * 查询单条数据
   *
   * @param sql SQL
   * @param clazz 结果类
   * @param <T> 结果类型
   * @return 结果
   */
  <T> T selectOne(String sql, Class<T> clazz);

  /**
   * 查询单条数据
   *
   * @param sql SQL
   * @param parameters SQL参数
   * @param clazz 结果类
   * @param <T> 结果类型
   * @return 结果
   */
  <T> T selectOne(String sql, Map<String, Object> parameters, Class<T> clazz);

  /**
   * 查询列表数据
   *
   * @param sql SQL
   * @param clazz 结果类
   * @param <T> 结果类型
   * @return 结果
   */
  <T> List<T> selectList(String sql, Class<T> clazz);

  /**
   * 查询列表数据
   *
   * @param sql SQL
   * @param parameters SQL参数
   * @param clazz 结果类
   * @param <T> 结果类型
   * @return 结果
   */
  <T> List<T> selectList(String sql, Map<String, Object> parameters, Class<T> clazz);

  /**
   * 查询分页数据
   *
   * @param sql SQL
   * @param page 分页对象
   * @param clazz 结果类
   * @param <T> 结果类型
   * @return 结果
   */
  <T> IPage<T> selectPage(String sql, Page<T> page, Class<T> clazz);

  /**
   * 查询分页数据
   *
   * @param sql SQL
   * @param parameters SQL参数
   * @param page 分页对象
   * @param clazz 结果类
   * @param <T> 结果类型
   * @return 结果
   */
  <T> IPage<T> selectPage(String sql, Page<T> page, Map<String, Object> parameters, Class<T> clazz);

  /**
   * 查询列表数据，并根据其中一个字段转为Map
   *
   * @param sql SQL
   * @param mapKeyField Map键对应的字段名称
   * @param clazz 结果类
   * @param <T> 结果类型
   * @return 结果
   */
  <T> Map<String, T> selectMap(String sql, String mapKeyField, Class<T> clazz);

  /**
   * 查询列表数据，并根据其中一个字段转为Map
   *
   * @param sql SQL
   * @param parameters SQL参数
   * @param mapKeyField Map键对应的字段名称
   * @param clazz 结果类
   * @param <T> 结果类型
   * @return 结果
   */
  <T> Map<String, T> selectMap(
      String sql, Map<String, Object> parameters, String mapKeyField, Class<T> clazz);

  /**
   * 插入数据
   *
   * @param sql SQL
   * @return 影响行数
   */
  int insert(String sql);

  /**
   * 插入数据
   *
   * @param sql SQL
   * @param parameters SQL参数
   * @return 影响行数
   */
  int insert(String sql, Map<String, Object> parameters);

  /**
   * 批量插入
   *
   * @param sql SQL
   * @param parameterMaps SQL参数集合
   */
  void batchInsert(String sql, Collection<Map<String, Object>> parameterMaps);

  /**
   * 更新数据
   *
   * @param sql SQL
   * @return 影响行数
   */
  int update(String sql);

  /**
   * 更新数据
   *
   * @param sql SQL
   * @param parameters SQL参数
   * @return 影响行数
   */
  int update(String sql, Map<String, Object> parameters);

  /**
   * 批量更新
   *
   * @param sql SQL
   * @param parameterMaps SQL参数集合
   */
  void batchUpdate(String sql, Collection<Map<String, Object>> parameterMaps);

  /**
   * 删除数据
   *
   * @param sql SQL
   * @return 影响行数
   */
  int delete(String sql);

  /**
   * 删除数据
   *
   * @param sql SQL
   * @param parameters SQL参数
   * @return 影响行数
   */
  int delete(String sql, Map<String, Object> parameters);

  /**
   * 批量删除
   *
   * @param sql SQL
   * @param parameterMaps SQL参数集合
   */
  void batchDelete(String sql, Collection<Map<String, Object>> parameterMaps);
}
