package org.elsfs.tool.sql.executor;

import java.util.List;
import org.elsfs.tool.sql.builder.GenericSelectSql;
import org.elsfs.tool.sql.interfaces.SqlExecutor;

/**
 * 查询列表数据SQL执行器实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class QueryListSqlExecutor<R> extends GenericSelectSql<QueryListSqlExecutor<R>>
    implements SqlExecutor<List<R>> {

  /** 通用SQL执行器 */
  private final GenericSqlExecutor genericSqlExecutor;

  /** 结果类 */
  private final Class<R> clazz;

  public QueryListSqlExecutor(GenericSqlExecutor genericSqlExecutor, Class<R> clazz) {
    this.genericSqlExecutor = genericSqlExecutor;
    this.clazz = clazz;
  }

  /**
   * 执行SQL
   *
   * @return 结果
   */
  @Override
  public List<R> execute() {
    return this.genericSqlExecutor.selectList(
        this.buildSqlFragment(), this.getSqlParameterManager().getSqlParameters(), this.clazz);
  }

  @Override
  protected String getTableName(Class<?> entityClass) {
    // todo
    return null;
  }
}
