package org.elsfs.tool.sql.executor;

import org.elsfs.tool.sql.builder.GenericSelectSql;
import org.elsfs.tool.sql.interfaces.SqlExecutor;

/**
 * 查询单条数据SQL执行器实现
 *
 * @param <R> 结果类型
 * @author zeng
 * @version 0.0.4
 */
public class QueryOneSqlExecutor<R> extends GenericSelectSql<QueryOneSqlExecutor<R>>
    implements SqlExecutor<R> {

  /** 通用SQL执行器 */
  private final GenericSqlExecutor genericSqlExecutor;

  /** 结果类 */
  private final Class<R> clazz;

  public QueryOneSqlExecutor(GenericSqlExecutor genericSqlExecutor, Class<R> clazz) {
    this.genericSqlExecutor = genericSqlExecutor;
    this.clazz = clazz;
  }

  /**
   * 执行SQL
   *
   * @return 结果
   */
  @Override
  public R execute() {
    this.where().limit(1);
    return this.genericSqlExecutor.selectOne(
        this.buildSqlFragment(), this.getSqlParameterManager().getSqlParameters(), this.clazz);
  }

  @Override
  protected String getTableName(Class<?> entityClass) {
    // todo
    return null;
  }
}
