package org.elsfs.tool.sql.executor;

import org.elsfs.tool.sql.builder.GenericUpdateSql;
import org.elsfs.tool.sql.interfaces.SqlExecutor;

/**
 * 更新SQL执行器
 *
 * @author zeng
 * @version 0.0.4
 */
public class UpdateSqlExecutor extends GenericUpdateSql<UpdateSqlExecutor>
    implements SqlExecutor<Integer> {

  /** 通用SQL执行器 */
  private final GenericSqlExecutor genericSqlExecutor;

  public UpdateSqlExecutor(GenericSqlExecutor genericSqlExecutor) {
    this.genericSqlExecutor = genericSqlExecutor;
  }

  /**
   * 执行SQL
   *
   * @return 结果
   */
  @Override
  public Integer execute() {
    return this.genericSqlExecutor.update(
        this.buildSqlFragment(), this.getSqlParameterManager().getSqlParameters());
  }

  @Override
  protected String getTableName(Class<?> entityClass) {
    // todo
    return null;
  }
}
