package org.elsfs.tool.sql.from;

import org.elsfs.tool.core.text.StrFormatter;

/**
 * 标准实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class StandardFromItem implements FromItem {

  /** 表名 */
  private final String table;

  /** 表别名 */
  private final String tableAlias;

  public StandardFromItem(String table, String tableAlias) {
    this.table = table;
    this.tableAlias = tableAlias;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    if (this.tableAlias == null) {
      return StrFormatter.format("FROM {}", this.table);
    }

    return StrFormatter.format("FROM {} AS {}", this.table, this.tableAlias);
  }

  /**
   * 获取表别名
   *
   * @return 表别名
   */
  @Override
  public String getTableAlias() {
    return tableAlias;
  }
}
