package org.elsfs.tool.sql.group;

import java.util.Collection;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 标准分组实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class StandardGroupBy implements GroupByItem {

  /** 字段名称 */
  private final Collection<String> fields;

  public StandardGroupBy(Collection<String> fields) {
    this.fields = fields;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "GROUP BY {}",
        this.fields.stream()
            .map(NamingCase::toUnderlineCase)
            .collect(Collectors.joining(SqlPool.COMMA_WITH_SPACE)));
  }
}
