package org.elsfs.tool.sql.insert;

import java.util.Collection;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 标准实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class StandardInsertIntoItem implements InsertIntoItem {

  /** 插入表 */
  private final String table;

  /** 插入字段集合 */
  private final Collection<String> insertFields;

  public StandardInsertIntoItem(String table, Collection<String> insertFields) {
    this.table = table;
    this.insertFields = insertFields;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "INSERT INTO {}({})",
        this.table,
        this.insertFields.stream()
            .map(NamingCase::toUnderlineCase)
            .collect(Collectors.joining(SqlPool.COMMA_WITH_SPACE)));
  }
}
