package org.elsfs.tool.sql.interfaces;

import java.util.Collection;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * 可排序条件
 *
 * @param <C> 子类具体类型
 * @author zeng
 * @since 0.0.4
 */
public interface SortableCondition<C extends SortableCondition<C>> extends Condition<C> {

  /**
   * 升序排序
   *
   * @param fields 排序字段名称
   * @return 具体实现
   */
  C orderByAsc(String... fields);

  /**
   * 升序排序
   *
   * @param fields 排序字段枚举
   * @return 具体实现
   */
  C orderByAsc(Enum<?>... fields);

  /**
   * 升序排序
   *
   * @param fields 排序字段名称
   * @return 具体实现
   */
  C orderByAsc(Collection<String> fields);

  /**
   * 升序排序
   *
   * @param condition 条件
   * @param fields 排序字段名称
   * @return 具体实现
   */
  default C orderByAsc(boolean condition, String... fields) {
    if (condition) {
      return this.orderByAsc(fields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 升序排序
   *
   * @param condition 条件
   * @param fields 排序字段枚举
   * @return 具体实现
   */
  default C orderByAsc(boolean condition, Enum<?>... fields) {
    if (condition) {
      return this.orderByAsc(fields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 升序排序
   *
   * @param condition 条件
   * @param fields 排序字段名称
   * @return 具体实现
   */
  default C orderByAsc(boolean condition, Collection<String> fields) {
    if (condition) {
      return this.orderByAsc(fields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 升序排序
   *
   * @param fields 排序字段枚举
   * @return 具体实现
   */
  C orderByEnumAsc(Collection<Enum<?>> fields);

  /**
   * 升序排序
   *
   * @param condition 条件
   * @param fields 排序字段枚举
   * @return 具体实现
   */
  default C orderByEnumAsc(boolean condition, Collection<Enum<?>> fields) {
    if (condition) {
      return this.orderByEnumAsc(fields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 降序排序
   *
   * @param fields 排序字段名称
   * @return 具体实现
   */
  C orderByDesc(String... fields);

  /**
   * 降序排序
   *
   * @param fields 排序字段枚举
   * @return 具体实现
   */
  C orderByDesc(Enum<?>... fields);

  /**
   * 降序排序
   *
   * @param fields 排序字段名称
   * @return 具体实现
   */
  C orderByDesc(Collection<String> fields);

  /**
   * 降序排序
   *
   * @param condition 条件
   * @param fields 排序字段名称
   * @return 具体实现
   */
  default C orderByDesc(boolean condition, String... fields) {
    if (condition) {
      return this.orderByDesc(fields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 降序排序
   *
   * @param condition 条件
   * @param fields 排序字段枚举
   * @return 具体实现
   */
  default C orderByDesc(boolean condition, Enum<?>... fields) {
    if (condition) {
      return this.orderByDesc(fields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 降序排序
   *
   * @param condition 条件
   * @param fields 排序字段名称
   * @return 具体实现
   */
  default C orderByDesc(boolean condition, Collection<String> fields) {
    if (condition) {
      return this.orderByDesc(fields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 降序排序
   *
   * @param fields 排序字段枚举
   * @return 具体实现
   */
  C orderByEnumDesc(Collection<Enum<?>> fields);

  /**
   * 降序排序
   *
   * @param condition 条件
   * @param fields 排序字段枚举
   * @return 具体实现
   */
  default C orderByEnumDesc(boolean condition, Collection<Enum<?>> fields) {
    if (condition) {
      return this.orderByEnumDesc(fields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 排序
   *
   * @param isAsc 是否升序
   * @param fields 排序字段名称
   * @return 具体实现
   */
  C orderBy(boolean isAsc, String... fields);

  /**
   * 排序
   *
   * @param isAsc 是否升序
   * @param fields 排序字段枚举
   * @return 具体实现
   */
  C orderBy(boolean isAsc, Enum<?>... fields);

  /**
   * 排序
   *
   * @param isAsc 是否升序
   * @param fields 排序字段名称
   * @return 具体实现
   */
  C orderBy(boolean isAsc, Collection<String> fields);

  /**
   * 排序
   *
   * @param condition 条件
   * @param isAsc 是否升序
   * @param fields 排序字段名称
   * @return 具体实现
   */
  default C orderBy(boolean condition, boolean isAsc, String... fields) {
    if (condition) {
      return this.orderBy(isAsc, fields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 排序
   *
   * @param condition 条件
   * @param isAsc 是否升序
   * @param fields 排序字段枚举
   * @return 具体实现
   */
  default C orderBy(boolean condition, boolean isAsc, Enum<?>... fields) {
    if (condition) {
      return this.orderBy(isAsc, fields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 排序
   *
   * @param condition 条件
   * @param isAsc 是否升序
   * @param fields 排序字段名称
   * @return 具体实现
   */
  default C orderBy(boolean condition, boolean isAsc, Collection<String> fields) {
    if (condition) {
      return this.orderBy(isAsc, fields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 排序
   *
   * @param condition 条件
   * @param isAsc 是否升序
   * @param fields 排序字段枚举
   * @return 具体实现
   */
  default C orderByEnum(boolean condition, boolean isAsc, Collection<Enum<?>> fields) {
    if (condition) {
      return this.orderByEnum(isAsc, fields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 排序
   *
   * @param isAsc 是否升序
   * @param fields 排序字段枚举
   * @return 具体实现
   */
  C orderByEnum(boolean isAsc, Collection<Enum<?>> fields);

  /**
   * 限制数量
   *
   * @param number 数量
   * @return 具体实现
   */
  C limit(long number);

  /**
   * 限制数量
   *
   * @param condition 条件
   * @param number 数量
   * @return 具体实现
   */
  default C limit(boolean condition, long number) {
    if (condition) {
      return this.limit(number);
    }

    return CastUtils.cast(this);
  }
}
