package org.elsfs.tool.sql.interfaces.inset;

import java.util.Collection;
import java.util.Map;
import org.elsfs.tool.sql.interfaces.Completable;
import org.elsfs.tool.sql.interfaces.SqlFragment;
import org.elsfs.tool.sql.interfaces.update.Settable;

/**
 * 插入SQL
 *
 * @param <C> 子类具体类型
 * @author zeng
 * @since 0.0.4
 */
public interface InsertSql<C extends InsertSql<C>> extends SqlFragment {

  /**
   * 插入的表
   *
   * @param entityClass 实体类
   * @return 具体实现
   */
  C insertInto(Class<?> entityClass);

  /**
   * 插入的表
   *
   * @param table 表名
   * @return 具体实现
   */
  C insertInto(String table);

  /**
   * 插入的字段
   *
   * @param fields 字段名称列表
   * @return 具体实现
   */
  C fields(String... fields);

  /**
   * 插入的字段
   *
   * @param fields 字段名称枚举列表
   * @return 具体实现
   */
  C fields(Enum<?>... fields);

  /**
   * 插入的字段
   *
   * @param fields 字段名称集合
   * @return 具体实现
   */
  C fields(Collection<String> fields);

  /**
   * 插入的字段
   *
   * @param fields 字段名称枚举集合
   * @return 具体实现
   */
  C fieldsEnum(Collection<Enum<?>> fields);

  /**
   * 插入的值
   *
   * @param value 值Map
   * @return 具体实现
   */
  C values(Map<String, Object> value);

  /**
   * 批量插入的值集合
   *
   * @param values 值集合
   * @return 具体实现
   */
  C values(Collection<Map<String, Object>> values);

  /**
   * 插入冲突时
   *
   * @param constraintName 冲突的约束名称
   * @return 具体实现
   */
  C onConflict(String constraintName);

  /**
   * 冲突时啥也不干
   *
   * @return 具体实现
   */
  C doNothing();

  /**
   * 冲突时执行更新语句
   *
   * @return 冲突更新SQl
   */
  ConflictUpdateSql<C> doUpdate();

  /**
   * 冲突更新SQl
   *
   * @param <C> 具体实现类型
   */
  interface ConflictUpdateSql<C>
      extends Settable<ConflictUpdateSql<C>>, Completable<C>, SqlFragment {

    /**
     * 设置字段表达式
     *
     * @param field 字段名称
     * @param excludedField 冲突值中的字段名称
     * @return 具体实现
     */
    ConflictUpdateSql<C> setConflict(String field, String excludedField);

    /**
     * 设置字段表达式
     *
     * @param field 字段枚举
     * @param excludedField 冲突值中的字段名称
     * @return 具体实现
     */
    ConflictUpdateSql<C> setConflict(Enum<?> field, Enum<?> excludedField);
  }
}
