package org.elsfs.tool.sql.interfaces.join;

import java.util.function.Consumer;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * join = 条件
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinEq<Children> extends ResolveFieldName {

  /**
   * 相等条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children eq(String leftField, String rightField) {
    return eq(true, leftField, rightField);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  Children eq(boolean condition, String leftField, String rightField);

  /**
   * 相等条件
   *
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children eq(Enum<?> leftField, Enum<?> rightField) {
    return eq(true, leftField, rightField);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children eq(boolean condition, Enum<?> leftField, Enum<?> rightField) {
    return eq(true, this.resolveFieldName(leftField), this.resolveFieldName(rightField));
  }

  /**
   * 相等条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children eq(
      String leftTableAlias, Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return eq(true, leftTableAlias, leftField, rightTableAlias, rightField);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children eq(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      String rightTableAlias,
      Enum<?> rightField) {
    return this.eq(
        condition,
        this.resolveFieldName(leftTableAlias, leftField),
        this.resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 相等条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children eq(String leftTableAlias, Enum<?> leftField, Enum<?> rightField) {
    return eq(true, leftTableAlias, leftField, rightField);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children eq(
      boolean condition, String leftTableAlias, Enum<?> leftField, Enum<?> rightField) {
    return eq(
        condition,
        this.resolveFieldName(leftTableAlias, leftField),
        this.resolveFieldName(rightField));
  }

  /**
   * 相等条件
   *
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children eq(Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return eq(true, leftField, rightTableAlias, rightField);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children eq(
      boolean condition, Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return eq(
        condition,
        this.resolveFieldName(leftField),
        this.resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 相等条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children eq(String leftField, Enum<?> rightField) {
    return eq(true, leftField, rightField);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children eq(boolean condition, String leftField, Enum<?> rightField) {
    return this.eq(condition, leftField, this.resolveFieldName(rightField));
  }

  /**
   * 相等条件
   *
   * @param leftField 左边字段名称
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children eq(String leftField, String rightTableAlias, Enum<?> rightField) {
    return eq(true, leftField, rightTableAlias, rightField);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children eq(
      boolean condition, String leftField, String rightTableAlias, Enum<?> rightField) {
    return this.eq(condition, leftField, this.resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 相等条件
   *
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children eq(Enum<?> leftField, String rightField) {
    return eq(true, leftField, rightField);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children eq(boolean condition, Enum<?> leftField, String rightField) {
    return this.eq(condition, this.resolveFieldName(leftField), rightField);
  }

  /**
   * 相等条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children eq(String leftTableAlias, Enum<?> leftField, String rightField) {
    return eq(true, leftTableAlias, leftField, rightField);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children eq(
      boolean condition, String leftTableAlias, Enum<?> leftField, String rightField) {
    return this.eq(condition, this.resolveFieldName(leftTableAlias, leftField), rightField);
  }

  /**
   * 相等条件
   *
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children eq(String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return eq(true, leftField, sqlBuilderConsumer);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  Children eq(boolean condition, String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer);

  /**
   * 相等条件
   *
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children eq(Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return eq(true, leftField, sqlBuilderConsumer);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children eq(
      boolean condition, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return this.eq(condition, this.resolveFieldName(leftField), sqlBuilderConsumer);
  }

  /**
   * 相等条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children eq(
      String leftTableAlias, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return eq(true, leftTableAlias, leftField, sqlBuilderConsumer);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children eq(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return eq(condition, this.resolveFieldName(leftTableAlias, leftField), sqlBuilderConsumer);
  }

  /**
   * 相等条件
   *
   * @param leftField 左边字段名称
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children eqValue(String leftField, Object rightValue) {
    return eqValue(true, leftField, rightValue);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightValue 右边值
   * @return 具体实现
   */
  Children eqValue(boolean condition, String leftField, Object rightValue);

  /**
   * 相等条件
   *
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children eqValue(Enum<?> leftField, Object rightValue) {
    return eqValue(true, leftField, rightValue);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children eqValue(boolean condition, Enum<?> leftField, Object rightValue) {
    return this.eqValue(condition, this.resolveFieldName(leftField), rightValue);
  }

  /**
   * 相等条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children eqValue(String leftTableAlias, Enum<?> leftField, Object rightValue) {
    return eqValue(true, leftTableAlias, leftField, rightValue);
  }

  /**
   * 相等条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children eqValue(
      boolean condition, String leftTableAlias, Enum<?> leftField, Object rightValue) {
    return this.eqValue(condition, this.resolveFieldName(leftTableAlias, leftField), rightValue);
  }
}
