package org.elsfs.tool.sql.interfaces.join;

import java.util.function.Consumer;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * 大于等于
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinGe<Children> extends ResolveFieldName {

  /**
   * 大于等于条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children ge(String leftField, String rightField) {
    return ge(true, leftField, rightField);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  Children ge(boolean condition, String leftField, String rightField);

  /**
   * 大于等于条件
   *
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ge(Enum<?> leftField, Enum<?> rightField) {
    return ge(true, leftField, rightField);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ge(boolean condition, Enum<?> leftField, Enum<?> rightField) {
    return this.ge(condition, this.resolveFieldName(leftField), this.resolveFieldName(rightField));
  }

  /**
   * 大于等于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ge(
      String leftTableAlias, Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return ge(true, leftTableAlias, leftField, rightTableAlias, rightField);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ge(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      String rightTableAlias,
      Enum<?> rightField) {
    return this.ge(
        condition,
        this.resolveFieldName(leftTableAlias, leftField),
        this.resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 大于等于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ge(String leftTableAlias, Enum<?> leftField, Enum<?> rightField) {
    return ge(true, leftTableAlias, leftField, rightField);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ge(
      boolean condition, String leftTableAlias, Enum<?> leftField, Enum<?> rightField) {
    return this.ge(
        condition,
        this.resolveFieldName(leftTableAlias, leftField),
        this.resolveFieldName(rightField));
  }

  /**
   * 大于等于条件
   *
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ge(Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return ge(true, leftField, rightTableAlias, rightField);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ge(
      boolean condition, Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return this.ge(
        condition,
        this.resolveFieldName(leftField),
        this.resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 大于等于条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ge(String leftField, Enum<?> rightField) {
    return ge(true, leftField, rightField);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ge(boolean condition, String leftField, Enum<?> rightField) {
    return this.ge(condition, leftField, this.resolveFieldName(rightField));
  }

  /**
   * 大于等于条件
   *
   * @param leftField 左边字段名称
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ge(String leftField, String rightTableAlias, Enum<?> rightField) {
    return ge(true, leftField, rightTableAlias, rightField);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children ge(
      boolean condition, String leftField, String rightTableAlias, Enum<?> rightField) {
    return this.ge(condition, leftField, this.resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 大于等于条件
   *
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children ge(Enum<?> leftField, String rightField) {
    return ge(true, leftField, rightField);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children ge(boolean condition, Enum<?> leftField, String rightField) {
    return this.ge(condition, resolveFieldName(leftField), rightField);
  }

  /**
   * 大于等于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children ge(String leftTableAlias, Enum<?> leftField, String rightField) {
    return ge(true, leftTableAlias, leftField, rightField);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children ge(
      boolean condition, String leftTableAlias, Enum<?> leftField, String rightField) {
    return this.ge(condition, resolveFieldName(leftTableAlias, leftField), rightField);
  }

  /**
   * 大于等于条件
   *
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children ge(String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return ge(true, leftField, sqlBuilderConsumer);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  Children ge(boolean condition, String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer);

  /**
   * 大于等于条件
   *
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children ge(Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return ge(true, leftField, sqlBuilderConsumer);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children ge(
      boolean condition, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return this.ge(condition, resolveFieldName(leftField), sqlBuilderConsumer);
  }

  /**
   * 大于等于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children ge(
      String leftTableAlias, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return ge(true, leftTableAlias, leftField, sqlBuilderConsumer);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children ge(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return this.ge(condition, resolveFieldName(leftTableAlias, leftField), sqlBuilderConsumer);
  }

  /**
   * 大于等于条件
   *
   * @param leftField 左边字段名称
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children geValue(String leftField, Object rightValue) {
    return this.geValue(true, leftField, rightValue);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightValue 右边值
   * @return 具体实现
   */
  Children geValue(boolean condition, String leftField, Object rightValue);

  /**
   * 大于等于条件
   *
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children geValue(Enum<?> leftField, Object rightValue) {
    return geValue(true, leftField, rightValue);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children geValue(boolean condition, Enum<?> leftField, Object rightValue) {
    return this.geValue(condition, resolveFieldName(leftField), rightValue);
  }

  /**
   * 大于等于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children geValue(String leftTableAlias, Enum<?> leftField, Object rightValue) {
    return geValue(true, leftTableAlias, leftField, rightValue);
  }

  /**
   * 大于等于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children geValue(
      boolean condition, String leftTableAlias, Enum<?> leftField, Object rightValue) {
    return this.geValue(condition, resolveFieldName(leftTableAlias, leftField), rightValue);
  }
}
