package org.elsfs.tool.sql.interfaces.join;

import org.elsfs.tool.sql.resolve.ResolveFieldName;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * the is {@link JoinNotLikeRight}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinNotLikeRight<Children> extends ResolveFieldName {

  /**
   * 非右模糊匹配条件
   *
   * @param field 字段名称
   * @param value 匹配值
   * @return 具体实现
   */
  Children notLikeRight(String field, String value);

  /**
   * 非右模糊匹配条件
   *
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  Children notLikeRight(Enum<?> field, String value);

  /**
   * 非右模糊匹配条件
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  Children notLikeRight(String tableAlias, Enum<?> field, String value);

  /**
   * 非右模糊匹配条件
   *
   * @param condition 条件
   * @param field 字段名称
   * @param value 匹配值
   * @return 具体实现
   */
  default Children notLikeRight(boolean condition, String field, String value) {
    if (condition) {
      return this.notLikeRight(field, value);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非右模糊匹配条件
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  default Children notLikeRight(boolean condition, Enum<?> field, String value) {
    if (condition) {
      return this.notLikeRight(field, value);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非右模糊匹配条件
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  default Children notLikeRight(boolean condition, String tableAlias, Enum<?> field, String value) {
    if (condition) {
      return this.notLikeRight(tableAlias, field, value);
    }

    return CastUtils.cast(this);
  }
}
