package org.elsfs.tool.sql.interfaces.single;

/**
 * the is {@link Between}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface Between<Children> {

  /**
   * 范围
   *
   * @param field 字段名
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  Children between(String field, Object leftValue, Object rightValue);

  /**
   * 范围
   *
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  Children between(Enum<?> field, Object leftValue, Object rightValue);

  /**
   * 范围
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  Children between(String tableAlias, Enum<?> field, Object leftValue, Object rightValue);

  /**
   * 范围
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  Children between(boolean condition, String field, Object leftValue, Object rightValue);

  /**
   * 范围
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  Children between(boolean condition, Enum<?> field, Object leftValue, Object rightValue);

  /**
   * 范围
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  Children between(
      boolean condition, String tableAlias, Enum<?> field, Object leftValue, Object rightValue);
}
