package org.elsfs.tool.sql.interfaces.single;

import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * the is {@link Eq}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface Eq<Children> extends ResolveFieldName {

  /**
   * 等于
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children eq(String field, Object value);

  /**
   * 等于
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children eq(Enum<?> field, Object value) {
    return this.eq(this.resolveFieldName(field), value);
  }

  /**
   * 等于
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  default Children eq(String tableAlias, Enum<?> field, Object value) {
    return this.eq(this.resolveFieldName(tableAlias, field), value);
  }

  /**
   * 等于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children eq(boolean condition, String field, Object value);

  /**
   * 等于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children eq(boolean condition, Enum<?> field, Object value);

  /**
   * 等于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children eq(boolean condition, String tableAlias, Enum<?> field, Object value);

  /**
   * 不等于
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children ne(String field, Object value);

  /**
   * 不等于
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children ne(Enum<?> field, Object value);

  /**
   * 不等于
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children ne(String tableAlias, Enum<?> field, Object value);

  /**
   * 不等于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children ne(boolean condition, String field, Object value);

  /**
   * 不等于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children ne(boolean condition, Enum<?> field, Object value);

  /**
   * 不等于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children ne(boolean condition, String tableAlias, Enum<?> field, Object value);

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children eqSql(boolean condition, String field, String sqlValue);

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children eqSql(boolean condition, Enum<?> field, String sqlValue);

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children eqSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue);

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children eqSql(String field, String sqlValue);

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children eqSql(Enum<?> field, String sqlValue);

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param tableAlias 字段表别名
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children eqSql(String tableAlias, Enum<?> field, String sqlValue);
}
