package org.elsfs.tool.sql.interfaces.single;

/**
 * the is { {@link Gt}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface Gt<Children> {

  /**
   * 大于
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children gt(String field, Object value);

  /**
   * 大于
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children gt(Enum<?> field, Object value);

  /**
   * 大于
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children gt(String tableAlias, Enum<?> field, Object value);

  /**
   * 大于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children gt(boolean condition, String field, Object value);

  /**
   * 大于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children gt(boolean condition, Enum<?> field, Object value);

  /**
   * 大于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children gt(boolean condition, String tableAlias, Enum<?> field, Object value);

  /**
   * 字段 &gt; ( sql语句 )
   *
   * <p>例1: gtSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children gtSql(boolean condition, String field, String sqlValue);

  /**
   * 字段 &gt; ( sql语句 )
   *
   * <p>例1: gtSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children gtSql(boolean condition, Enum<?> field, String sqlValue);

  /**
   * 字段 &gt; ( sql语句 )
   *
   * <p>例1: gtSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children gtSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue);

  /**
   * 字段 &gt; ( sql语句 )
   *
   * <p>例1: gtSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children gtSql(String field, String sqlValue);

  /**
   * 字段 &gt; ( sql语句 )
   *
   * <p>例1: gtSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children gtSql(Enum<?> field, String sqlValue);

  /**
   * 字段 &gt; ( sql语句 )
   *
   * <p>例1: gtSql("id", "select id from table where name = 'JunJun'")
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children gtSql(String tableAlias, Enum<?> field, String sqlValue);
}
