package org.elsfs.tool.sql.interfaces.single;

/**
 * the is {@link JoinNotLikeLeft}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinNotLikeLeft<Children> {

  /**
   * 非左模糊匹配条件
   *
   * @param field 字段名称
   * @param value 匹配值
   * @return 具体实现
   */
  Children notLikeLeft(String field, String value);

  /**
   * 非左模糊匹配条件
   *
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  Children notLikeLeft(Enum<?> field, String value);

  /**
   * 非左模糊匹配条件
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  Children notLikeLeft(String tableAlias, Enum<?> field, String value);

  /**
   * 非右模糊匹配条件
   *
   * @param field 字段名称
   * @param value 匹配值
   * @return 具体实现
   */
  Children notLikeRight(String field, String value);

  /**
   * 非右模糊匹配条件
   *
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  Children notLikeRight(Enum<?> field, String value);

  /**
   * 非右模糊匹配条件
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  Children notLikeRight(String tableAlias, Enum<?> field, String value);
}
