package org.elsfs.tool.sql.interfaces.single;

/**
 * the is {@link Le}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface Le<Children> {

  /**
   * 小于等于
   *
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children le(String field, Object value);

  /**
   * 小于等于
   *
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children le(Enum<?> field, Object value);

  /**
   * 小于等于
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children le(String tableAlias, Enum<?> field, Object value);

  /**
   * 小于等于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  Children le(boolean condition, String field, Object value);

  /**
   * 小于等于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children le(boolean condition, Enum<?> field, Object value);

  /**
   * 小于等于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  Children le(boolean condition, String tableAlias, Enum<?> field, Object value);

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children leSql(boolean condition, String field, String sqlValue);

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children leSql(boolean condition, Enum<?> field, String sqlValue);

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children leSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue);

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children leSql(String field, String sqlValue);

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children leSql(Enum<?> field, String sqlValue);

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  Children leSql(String tableAlias, Enum<?> field, String sqlValue);
}
